<div class="max-w-3xl mx-auto p-6">
    <div class="bg-white shadow-2xl rounded-3xl p-8 border border-blue-50 relative overflow-hidden">
        <div class="absolute top-0 right-0 -mr-16 -mt-16 w-32 h-32 bg-blue-100 rounded-full opacity-50"></div>
        
        <h2 class="text-3xl font-black text-center text-blue-900 mb-2 tracking-tight">
            🚣‍♀️ Súmate al Club de Remo Estrella Blanca
        </h2>

        <p class="text-center text-slate-500 mb-8 font-medium">
            Completa tus datos y comienza a remar con nosotros
        </p>

        @if (session()->has('success'))
            <div class="mb-6 p-4 rounded-2xl bg-emerald-50 border border-emerald-200 text-emerald-700 text-center font-bold animate-bounce">
                ✅ {{ session('success') }}
            </div>
        @endif

        <form wire:submit.prevent="guardar" class=" ">
            <div class="{{$ok}} grid grid-cols-1 md:grid-cols-2 gap-6">

            
            {{-- RUT --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">RUT</label>
                <input type="text" wire:model.defer="rut" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none placeholder:text-slate-400" 
                    placeholder="12345678-9">
                @error('rut') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            {{-- Email --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Correo electrónico</label>
                <input type="email" wire:model.defer="email" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none" 
                    placeholder="correo@email.cl">
                @error('email') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            {{-- Nombres --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Nombres</label>
                <input type="text" wire:model.defer="nombres" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none">
                @error('nombres') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            {{-- Apellido paterno --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Apellido paterno</label>
                <input type="text" wire:model.defer="paterno" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none">
                @error('paterno') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            {{-- Apellido materno --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Apellido materno</label>
                <input type="text" wire:model.defer="materno" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none">
                @error('materno') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            {{-- Fecha nacimiento --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Fecha de nacimiento</label>
                <input type="date" wire:model.defer="nacimiento" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none">
                @error('nacimiento') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            {{-- Género --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Género</label>
                <select wire:model.defer="genero" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none appearance-none">
                    <option value="">Seleccione…</option>
                    <option value="M">Masculino</option>
                    <option value="F">Femenino</option>
                    <option value="O">Otro</option>
                </select>
                @error('genero') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            {{-- Nacionalidad --}}
            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Nacionalidad</label>
                <input type="text" wire:model.defer="nacionalidad" 
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none">
                @error('nacionalidad') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>

            <div class="space-y-1">
                <label class="block text-sm font-bold text-blue-900 ml-1">Telefono</label>                
                <input type="text" wire:model.defer="telefono"  placeholder="912345678"
                    class="w-full px-4 py-3 rounded-xl border-2 border-slate-100 bg-slate-50 text-slate-700 focus:border-blue-500 focus:bg-white focus:ring-4 focus:ring-blue-500/10 transition-all duration-200 outline-none">
                @error('telefono') <span class="text-xs text-red-500 font-semibold ml-1">{{ $message }}</span> @enderror
            </div>


            {{-- Botón --}}
            <div class="md:col-span-2 mt-6">
                <button
                    type="submit"
                    class="group relative w-full inline-flex items-center justify-center px-8 py-4 font-bold text-white transition-all duration-200 bg-blue-600 font-pj rounded-2xl focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-600 hover:bg-blue-700 shadow-lg shadow-blue-200 overflow-hidden">
                    <span class="relative z-10 flex items-center justify-center">
                         🚀 Enviar inscripción
                    </span>
                    <div class="absolute inset-0 w-full h-full transition-all duration-300 scale-0 group-hover:scale-100 group-hover:bg-white/10 rounded-2xl"></div>
                </button>
            </div>
            </div>
        </form>

        <p class="text-center text-xs font-medium text-slate-400 mt-8 uppercase tracking-widest">
            🛡️ El club validará tus datos antes de activar tu membresía
        </p>
    </div>
</div>