<?php

namespace App\Livewire\Socios;

use Livewire\Component;
use App\Models\Persona;

class Inscripcion extends Component
{
    public $rut;
    public $nombres;
    public $paterno;
    public $materno;
    public $nacimiento;
    public $telefono;
    public $genero;
    public $nacionalidad = 'Chilena';
    public $email;
    public $ok = '';

    protected $rules = [
        'rut'          => 'required|min:8|max:12',
        'nombres'      => 'required|string|min:2',
        'paterno'      => 'required|string|min:2',       
        //'nacimiento'   => 'required|date',
        //'genero'       => 'required',
        'nacionalidad' => 'required|string',
        'email'        => 'required|email',
        'telefono'        => 'required|min:9|max:12',
    ];

    protected $messages = [
        'rut.required' => 'El RUT es obligatorio 12345678-5',
        'nombres.required' => 'El Nombre es obligatorio',
        'paterno.required' => 'El Apellido es obligatorio',
        //'genero.required'       => 'Especificar Género',
        'nacionalidad.required'       => 'Especificar Nacionalidad',
       /// 'nacimiento.required'       => 'Fecha es obligatorio para calcular la Categoría',
        'email.email'  => 'El correo no es válido',
        'telefono.required'  => 'Formato válido 912345678',

    ];

    public function guardar()
    {
        $this->validate();

        Persona::create(
            [
                'rut'=>$this->rut,
                'nombres'=>$this->nombres,
                'paterno'=>$this->paterno,
                'materno'=>$this->materno,
                'nacimiento'=>$this->nacimiento,
                'genero'=>$this->genero,
                'nacionalidad'=>$this->nacionalidad,
                'email'=>$this->email,
            ]
        );
        $this->ok = 'hidden';
        session()->flash('success', '¡Inscripción enviada con éxito! 🥳');

        $this->reset();
    }

    public function render()
    {
        return view('livewire.socios.inscripcion');
    }
}
